from fastapi import FastAPI
from fastapi.middleware.cors import CORSMiddleware

app = FastAPI()

# Add CORS middleware
app.add_middleware(
    CORSMiddleware,
    allow_origins=["http://localhost:5173", "http://127.0.0.1:5173"],
    allow_credentials=True,
    allow_methods=["*"],
    allow_headers=["*"],
)

@app.get("/test/pois")
async def test_poi_endpoint(lat: float, lon: float):
    """Test POI endpoint"""
    return [
        {
            'id': 'test_poi_1',
            'lat': lat + 0.001,
            'lon': lon + 0.001,
            'name': 'Test Restaurant',
            'category': 'food',
            'distance': 0.1
        }
    ]

if __name__ == "__main__":
    import uvicorn
    uvicorn.run(app, host="0.0.0.0", port=8001)