from fastapi import Depends
from sqlalchemy.orm import Session

from routers.auth_router import get_current_user_with_db
from db.db_connection import get_db
from db import models

# Proper wrapper that ensures we return the authenticated user
def get_current_user(
    current_user: models.User = Depends(get_current_user_with_db),
) -> models.User:
    """
    Returns the authenticated user, re-exported from auth_router.
    """
    return current_user

# If you also need DB session
def get_db_session() -> Session:
    return Depends(get_db)
