from pydantic import BaseModel
from typing import Optional
from sqlalchemy import Column, Integer, String
from sqlalchemy.orm import relationship 
from db.db_connection import Base 

# ===============================
# SQLAlchemy ORM Model
# ===============================
class User(Base):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, autoincrement=True)
    email = Column(String(255), unique=True, nullable=False, index=True)
    hashed_password = Column(String(255), nullable=False)
    full_name = Column(String(255), nullable=True)
    phone = Column(String(50), nullable=True)
    is_active = Column(Integer, default=1)  # 1 = active, 0 = inactive
    
    # Relationship to Order model
    orders = relationship("Order", back_populates="user") 


# ===============================
# Pydantic Model for Input
# ===============================
class UserCreate(BaseModel):
    email: str
    password: str
    full_name: Optional[str] = None
    phone: Optional[str] = None


# ===============================
# Pydantic Model for Response
# ===============================
class UserResponse(BaseModel):
    id: int
    email: str
    full_name: Optional[str] = None
    phone: Optional[str] = None
    is_active: Optional[int] = 1

    class Config:
        from_attributes = True  # read directly from ORM objects
