import os

def create_env_file():
    """Create .env file for backend configuration"""
    
    env_content = """# Database Configuration
DB_USERNAME=kitamove_user
DB_PASSWORD=your_password_here
DB_HOST=localhost
DB_PORT=5432
DB_NAME=kitamove

# API Configuration
API_HOST=0.0.0.0
API_PORT=8000
DEBUG=True

# CORS Configuration
ALLOWED_ORIGINS=http://localhost:3000,http://localhost:5173
"""
    
    env_file_path = os.path.join(os.path.dirname(__file__), '.env')
    
    if os.path.exists(env_file_path):
        print(f"Warning: {env_file_path} already exists!")
        response = input("Do you want to overwrite it? (y/n): ")
        if response.lower() != 'y':
            print("Environment file creation cancelled.")
            return
    
    try:
        with open(env_file_path, 'w') as f:
            f.write(env_content)
        print(f"✅ Environment file created successfully: {env_file_path}")
        print("⚠️  Remember to update the database password in the .env file!")
    except Exception as e:
        print(f"❌ Error creating environment file: {e}")

if __name__ == "__main__":
    create_env_file()
