# PostgreSQL Setup for KitaMove Backend

## Prerequisites
- PostgreSQL installed on your system
- Python 3.8+ with pip

## Database Setup

### 1. Create Database
```sql
CREATE DATABASE kitamove;
CREATE USER kitamove_user WITH PASSWORD 'your_password';
GRANT ALL PRIVILEGES ON DATABASE kitamove TO kitamove_user;
```

### 2. Environment Variables
Create a `.env` file in the backend directory with:
```
DB_USERNAME=kitamove_user
DB_PASSWORD=your_password
DB_HOST=localhost
DB_PORT=5432
DB_NAME=kitamove
```

### 3. Install Dependencies
```bash
cd backend
pip install -r requirements.txt
```

### 4. Run Database Scripts
```bash
# Test database connection
python db/test_connection.py

# Import Sabah properties
python db/import_sabah_to_postgresql.py

# Populate lorry data
python db/populate_lorry_data.py
```

### 5. Start Backend
```bash
# Windows
start_backend.bat

# Or manually
uvicorn main:app --host 0.0.0.0 --port 8000 --reload
```

## Database Schema
The application uses SQLAlchemy models defined in `db/models/`:
- `house_model.py` - Property listings
- `lorry_model.py` - Moving services

## Troubleshooting
- Ensure PostgreSQL service is running
- Check firewall settings for port 5432
- Verify database credentials in `.env` file
